(function ($) {
  ("use strict");

  // Mean Menu
  jQuery(".mean-menu").meanmenu({
    meanScreenWidth: "991",
  });

  // $(document).ready(() => {
  //   const searchPlaces = document.getElementById("search-places");
  //   var autocomplete = new google.maps.places.Autocomplete(searchPlaces);

  //   autocomplete.addListener("place_changed", function () {
  //     var place = autocomplete.getPlace();
  //     searchPlaces.value = place.name;
  //   });
  // });

  // Header Sticky
  $(window).on("scroll", function () {
    if ($(this).scrollTop() > 120) {
      $(".navbar-area").addClass("is-sticky");
    } else {
      $(".navbar-area").removeClass("is-sticky");
    }
  });

  // Last Word Color JS
  $(".main-banner-content h1, .hero-content h1").html(function () {
    var text = $(this).text().trim().split(" ");
    var last = text.pop();
    return (
      text.join(" ") + (text.length > 0 ? " <span>" + last + "</span>" : last)
    );
  });

  // First Word Color JS
  $(".offer-content h2, .offer-time h2").html(function () {
    var text = $(this).text().trim().split(" ");
    var first = text.shift();
    return (
      (text.length > 0 ? "<span>" + first + "</span> " : first) + text.join(" ")
    );
  });

  // FAQ Accordion
  $(function () {
    $(".accordion")
      .find(".accordion-title")
      .on("click", function () {
        // Adds Active Class
        $(this).toggleClass("active");
        // Expand or Collapse This Panel
        $(this).next().slideToggle("fast");
        // Hide The Other Panels
        $(".accordion-content").not($(this).next()).slideUp("fast");
        // Removes Active Class From Other Titles
        $(".accordion-title").not($(this)).removeClass("active");
      });
  });

  // Video Popup JS
  $(".popup-youtube").magnificPopup({
    disableOn: 320,
    type: "iframe",
    mainClass: "mfp-fade",
    removalDelay: 160,
    preloader: false,
    fixedContentPos: false,
  });

  // Home Slides
  $(".home-slides").owlCarousel({
    loop: true,
    nav: false,
    dots: false,
    // autoplayHoverPause: true,
    autoplay: true,
    autoplayTimeout: 5000,
    smartSpeed: 750,
    items: 1,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
  });
  $(".home-slides").on("translate.owl.carousel", function () {
    $(".hero-content h2")
      .removeClass("animate__animated animate__fadeInUp")
      .css("opacity", "0");
    $(".hero-content p")
      .removeClass("animate__animated animate__fadeInUp")
      .css("opacity", "0");
    $(".hero-content .btn")
      .removeClass("animate__animated animate__fadeInUp")
      .css("opacity", "0");
  });
  $(".home-slides").on("translated.owl.carousel", function () {
    $(".hero-content h2")
      .addClass("animate__animated animate__fadeInUp")
      .css("opacity", "1");
    $(".hero-content p")
      .addClass("animate__animated animate__fadeInUp")
      .css("opacity", "1");
    $(".hero-content .btn")
      .addClass("animate__animated animate__fadeInUp")
      .css("opacity", "1");
  });

  // TV Show Slides
  $(".tv-show-slides").owlCarousel({
    loop: false,
    nav: false,
    dots: false,
    autoplayHoverPause: true,
    autoplay: true,
    mouseDrag: false,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
    responsive: {
      0: {
        items: 1,
      },
      576: {
        items: 2,
      },
      768: {
        items: 2,
      },
      1200: {
        items: 3,
      },
    },
  });

  // Blog Slides
  $(".blog-slides").owlCarousel({
    loop: false,
    nav: false,
    dots: true,
    autoplayHoverPause: true,
    autoplay: true,
    margin: 30,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
    responsive: {
      0: {
        items: 1,
      },
      768: {
        items: 2,
      },
      1200: {
        items: 3,
      },
    },
  });

  // Feedback Slides
  $(".feedback-slides").owlCarousel({
    loop: true,
    nav: false,
    dots: true,
    margin: 30,
    autoplayHoverPause: true,
    autoplay: true,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
    responsive: {
      0: {
        items: 1,
      },
      768: {
        items: 2,
      },
      1200: {
        items: 3,
      },
    },
  });

  // Select JS
  $("select:not(.multiple)").niceSelect();

  // $("select.multiple").multipleSelect();
  // offers slides
  $(".offers-slides").owlCarousel({
    loop: true,
    nav: true,
    dots: false,
    margin: 30,
    autoplayTimeout: 4000,
    smartSpeed: 750,
    autoplayHoverPause: true,
    autoplay: true,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
    responsive: {
      0: {
        items: 1,
      },
    },
  });
  // Count Time
  function makeTimer() {
    const timers = document.querySelectorAll(".has-timer");

    timers.forEach((element) => {
      const id = element.getAttribute("id");
      var endTime = new Date(element.getAttribute("data-end-date"));

      if (endTime < new Date()) {
        return;
      }

      var endTime = Date.parse(endTime) / 1000;
      var now = new Date();
      var now = Date.parse(now) / 1000;
      var timeLeft = endTime - now;
      var days = Math.floor(timeLeft / 86400);
      var hours = Math.floor((timeLeft - days * 86400) / 3600);
      var minutes = Math.floor((timeLeft - days * 86400 - hours * 3600) / 60);
      var seconds = Math.floor(
        timeLeft - days * 86400 - hours * 3600 - minutes * 60
      );
      if (hours < "10") {
        hours = "0" + hours;
      }
      if (minutes < "10") {
        minutes = "0" + minutes;
      }
      if (seconds < "10") {
        seconds = "0" + seconds;
      }
      $(`#${id} #days`).html(days + "<span>Days</span>");
      $(`#${id} #hours`).html(hours + "<span>Hours</span>");
      $(`#${id} #minutes`).html(minutes + "<span>Minutes</span>");
      $(`#${id} #seconds`).html(seconds + "<span>Seconds</span>");
    });
  }

  setInterval(function () {
    makeTimer();
  }, 1000);

  // Input Plus & Minus Number JS
  $(".input-counter").each(function () {
    var spinner = jQuery(this),
      input = spinner.find('input[type="text"]'),
      btnUp = spinner.find(".plus-btn"),
      btnDown = spinner.find(".minus-btn"),
      min = input.attr("min"),
      max = input.attr("max");

    btnUp.on("click", function () {
      var oldValue = parseFloat(input.val());
      if (oldValue >= max) {
        var newVal = oldValue;
      } else {
        var newVal = oldValue + 1;
      }
      spinner.find("input").val(newVal);
      spinner.find("input").trigger("change");
    });
    btnDown.on("click", function () {
      var oldValue = parseFloat(input.val());
      if (oldValue <= min) {
        var newVal = oldValue;
      } else {
        var newVal = oldValue - 1;
      }
      spinner.find("input").val(newVal);
      spinner.find("input").trigger("change");
    });
  });

  // Tabs
  (function ($) {
    $(".tab ul.tabs").addClass("active").find("> li:eq(0)").addClass("current");
    $(".tab ul.tabs li a").on("click", function (g) {
      var tab = $(this).closest(".tab"),
        index = $(this).closest("li").index();
      tab.find("ul.tabs > li").removeClass("current");
      $(this).closest("li").addClass("current");
      tab
        .find(".tab_content")
        .find("div.tabs_item")
        .not("div.tabs_item:eq(" + index + ")")
        .slideUp();
      tab
        .find(".tab_content")
        .find("div.tabs_item:eq(" + index + ")")
        .slideDown();
      g.preventDefault();
    });
  })(jQuery);

  // Subscribe form
  $(".newsletter-form")
    .validator()
    .on("submit", function (event) {
      if (event.isDefaultPrevented()) {
        // handle the invalid form...
        formErrorSub();
        submitMSGSub(false, "Please enter your email correctly.");
      } else {
        // everything looks good!
        event.preventDefault();
      }
    });
  function callbackFunction(resp) {
    if (resp.result === "success") {
      formSuccessSub();
    } else {
      formErrorSub();
    }
  }
  function formSuccessSub() {
    $(".newsletter-form")[0].reset();
    submitMSGSub(true, "Thank you for subscribing!");
    setTimeout(function () {
      $("#validator-newsletter").addClass("hide");
    }, 4000);
  }
  function formErrorSub() {
    $(".newsletter-form").addClass("animated shake");
    setTimeout(function () {
      $(".newsletter-form").removeClass("animated shake");
    }, 1000);
  }
  function submitMSGSub(valid, msg) {
    if (valid) {
      var msgClasses = "validation-success";
    } else {
      var msgClasses = "validation-danger";
    }
    $("#validator-newsletter").removeClass().addClass(msgClasses).text(msg);
  }
  // AJAX MailChimp
  $(".newsletter-form").ajaxChimp({
    url: "https://envytheme.us20.list-manage.com/subscribe/post?u=60e1ffe2e8a68ce1204cd39a5&amp;id=42d6d188d9", // Your url MailChimp
    callback: callbackFunction,
  });

  // Go to Top
  $(function () {
    // Scroll Event
    $(window).on("scroll", function () {
      var scrolled = $(window).scrollTop();
      if (scrolled > 600) $(".go-top").addClass("active");
      if (scrolled < 600) $(".go-top").removeClass("active");
    });
    // Click Event
    $(".go-top").on("click", function () {
      $("html, body").animate({ scrollTop: "0" }, 500);
    });
  });

  // WOW JS
  $(window).on("load", function () {
    if ($(".wow").length) {
      var wow = new WOW({
        boxClass: "wow", // animated element css class (default is wow)
        animateClass: "animated", // animation css class (default is animated)
        offset: 20, // distance to the element when triggering the animation (default is 0)
        mobile: true, // trigger animations on mobile devices (default is true)
        live: true, // act on asynchronously loaded content (default is true)
      });
      wow.init();
    }
  });

  // show subscription modal
  $(window).on("load", function () {
    setTimeout(function () {
      $("#sub-form-main").modal("show").fadeIn();
    }, 5000);
  });

  // Preloader Area
  // $(window).on("load", function () {
  //   $(".preloader").fadeOut();
  // });

  function generateUUID() {
    return "xxxx-xyxy-yyyy-xyxy".replace(/[xy]/g, function (c) {
      var r = (Math.random() * 16) | 0,
        v = c == "x" ? r : (r & 0x3) | 0x8;
      return v.toString(16);
    });
  }
  function showParticles(className) {
    // particles
    if ($(`.${className}`).length) {
      const hasParticles = document.querySelectorAll(`.${className}`);
      hasParticles.forEach((element) => {
        // check for parent class
        if (element.parentElement.classList.contains("cloned")) {
          element.setAttribute("id", generateUUID());
        }
        const id = element.getAttribute("id");
        /* particlesJS.load(@dom-id, @path-json, @callback (optional)); */
        particlesJS.load(id, "assets/particlesjs-config.json");
      });
    }
  }

  showParticles("has-particles");

  $(function () {
    $(".has-popup").popover({
      trigger: "hover",
    });
  });
})(jQuery);

try {
  // function to set a given theme/color-scheme
  function setTheme(themeName) {
    localStorage.setItem("kozi_theme", themeName);
    document.documentElement.className = themeName;
  }
  // function to toggle between light and dark theme
  function toggleTheme() {
    if (localStorage.getItem("kozi_theme") === "theme-dark") {
      setTheme("theme-light");
    } else {
      setTheme("theme-dark");
    }
  }
  // Immediately invoked function to set the theme on initial load
  (function () {
    if (localStorage.getItem("kozi_theme") === "theme-dark") {
      setTheme("theme-dark");
      document.getElementById("slider").checked = false;
    } else {
      setTheme("theme-light");
      document.getElementById("slider").checked = true;
    }
  })();
} catch (err) {}
